let objects = require('common/objects');
let metadata = require('common/metadata');
let templates = require('common/templates');

// query this number to find all related documents
let insNumber = 'N263288018';

// set new metadata to all found documents and folders
let meta = {
  isg_xpert_archive_insNumber: insNumber,
  isg_xpert_archive_insForename: 'Bernd',
  isg_xpert_archive_insSurname: 'Strebel',
  isg_xpert_archive_insName: 'Bernd Strebel',
  isg_xpert_archive_insBirthday: new Date('1960-03-10'),
};

let reference = {
  isg_xpert_archive_recordCounter: 3,
  area: ['mdb', 'archive', 'records', 'documents'],
  isg_xpert_archive_images: ['_38114_16100_11__1_10829161_20230607174802564984.pdf'],
  isg_xpert_archive_insSurname: 'Helbing',
  isg_xpert_archive_insBirthday: '1957-09-09T00:00:00.000Z',
  isg_xpert_archive_orderDate: '2023-06-07T00:00:00.000Z',
  isg_xpert_archive_orderNumber: 'A-10829161',
  isg_xpert_archive_imgName: '_38114_16100_11__1_10829161_20230607174802564984.pdf',
  ag_metadata_collection: 'isg_xpert_archive_Document',
  isg_xpert_archive_insNumber: 'N263288018',
  isg_xpert_archive_processLvl2: 'AU',
  isg_xpert_archive_archive: 'Archiv',
  isg_xpert_archive_processLvl3: 'Auftragsverwaltung',
  isg_xpert_archive_documents: 'Dokumente',
  isg_xpert_archive_documentCounter: 6,
  isg_xpert_archive_insPatId: 'PATID',
  isg_xpert_archive_records: 'Versicherte',
  isg_xpert_archive_processLvl1: 'Gutachten',
  isg_xpert_archive_processCode: '0',
  isg_xpert_archive_processDate: '2023-06-07T00:00:00.000Z',
  isg_xpert_archive_imgId: '_21337_13000_11__1_10829278_20230706085459050895.pdf',
  isg_xpert_archive_mdb: 'Medizinischer Dienst Bremen',
  isg_xpert_archive_insName: 'Monika Helbing',
  isg_xpert_archive_insForename: 'Monika',
};

// run query and set metadata
let query = 'area:mdb area:archive isg_xpert_archive_insnumber:' + insNumber;
objects
  .query(query)
  .find()
  .forEach(item => {
    metadata(meta).save(item);
  });

// find insurance folder and change name according to metadata
query = query + ' classname:FOLDEROBJECT';
let folder = objects.query(query).limit(1).find()[0];
folder.name = templates.fill(
  '${isg_xpert_archive_insNumber} - ${isg_xpert_archive_insName} - ${isg_xpert_archive_insBirthday:de|dd.MM.yyyy}',
  meta
);

'Done at ' + new Date();
